<div class="card overflow-hidden">
    <div class="card-body">
        <div class="d-flex">
            <div class="mt-2">
                <h6 class="">{{$title}}</h6>
                <h2 class="mb-0 number-font">{{number_format($currentValue)}}</h2>
            </div>
            <div class="ms-auto">
                <div class="chart-wrapper mt-1">
                    <canvas id="{{$type}}" class="h-8 w-9 chart-dropshadow"></canvas>
                </div>
            </div>
        </div>
        <span class="text-muted fs-12">
            <span style="color: {{$color}}">
                <i class="fe fe-arrow-up-circle"></i> {{$percentageChange}}%
            </span>
            Last week
        </span>
    </div>
</div>

@push('script')
@once
<!-- INTERNAL CHARTJS CHART JS-->
<script src="{{asset('backend/plugins/chart/Chart.bundle.js')}}"></script>
<script src="{{asset('backend/plugins/chart/rounded-barchart.js')}}"></script>
<script src="{{asset('backend/plugins/chart/utils.js')}}"></script>
@endonce
<script>
    var ctx = document.getElementById('{{$type}}').getContext('2d');
    ctx.height = 10;
    var myChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
            datasets: [{
                label: '{{$title}}',
                barGap: 0,
                barSizeRatio: 1,
                data: @json($chartData),
                backgroundColor: '{{$color}}',
                borderColor: '{{$color}}',
                pointBackgroundColor: '#fff',
                pointHoverBackgroundColor: '{{$color}}',
                pointBorderColor: '{{$color}}',
                pointHoverBorderColor: '{{$color}}',
                pointBorderWidth: 2,
                pointRadius: 2,
                pointHoverRadius: 2,
                borderWidth: 1
            }, ]
        },
        options: {
            maintainAspectRatio: false,
            legend: {
                display: false
            },
            responsive: true,
            tooltips: {
                enabled: false,
            },
            scales: {
                xAxes: [{
                    categoryPercentage: 1.0,
                    barPercentage: 1.0,
                    barDatasetSpacing: 0,
                    display: false,
                    barThickness: 5,
                    gridLines: {
                        color: 'transparent',
                        zeroLineColor: 'transparent'
                    },
                    ticks: {
                        fontSize: 2,
                        fontColor: 'transparent'
                    }
                }],
                yAxes: [{
                    display: false,
                    ticks: {
                        display: false,
                    }
                }]
            },
            title: {
                display: false,
            },
        }
    });
</script>
@endpush
